<?php

namespace App\Exports\SuperAdmin;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TherapistCommunityMainCategoriesExport implements FromArray, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    protected $therapistcommunity_main_categories;
    public function __construct($therapistcommunity_main_categories)
    {
        $this->therapistcommunity_main_categories = $therapistcommunity_main_categories;
    }
    public function array(): array
    {
        $data = [];
        foreach ($this->therapistcommunity_main_categories as $therapistcommunity_main_categories) {
            $single = [$therapistcommunity_main_categories->id, $therapistcommunity_main_categories->name, $therapistcommunity_main_categories->description,$therapistcommunity_main_categories->icon,$therapistcommunity_main_categories->image, $therapistcommunity_main_categories->is_active, $therapistcommunity_main_categories->slug, date_format($therapistcommunity_main_categories->created_at, 'd-m-Y')];
            $data[] = $single;
        }
        return $data;
    }
    public function headings(): array
    {
        return ["id", "name", "description","icon","image", "is_active", "slug", "created_at"];
    }
}
